/* Gestion des mouvements du pion bleu */

const myDiv  = document.querySelector('#my-div');
myDiv.ref_ms = { x: 0, y: 0 };

myDiv.addEventListener('mousedown', (e) =>
  {
  myDiv.ref_ms.x = e.clientX;
  myDiv.ref_ms.y = e.clientY;
  myDiv.classList.add('movCursor')

  if (myDiv.style.transform !== '')
    {
    let [ mx, my ] = myDiv.style.transform.match(/-?\d*\.?\d+/g).map(Number);
    myDiv.ref_ms.x -= mx;
    myDiv.ref_ms.y -= my;
    }
  })
window.addEventListener('mousemove', e =>
  {
  if (myDiv.classList.contains('movCursor')
    && e.clientX > 0 && e.clientY > 0 )
    {
    myDiv.style = `transform: translate(${e.clientX - myDiv.ref_ms.x}px, ${e.clientY - myDiv.ref_ms.y}px);`;
    }
  })
window.addEventListener('mouseup', () =>
  {
  myDiv.classList.remove('movCursor')
  })
