var TextAnimation = (function(){
	var module = {};
	module.animated = {};
	module.setText = function(selector, msg, durationMs, clearText){
		if(selector in module.animated){
			if(module.animated[selector]!=null){
				clearTimeout(module.animated[selector]);
				module.animated[selector] = null;
			}
		}
		var e = document.querySelector(selector);
		if(e){
			e.textContent = msg;
		}
		module.animated[selector] = setTimeout(function(){
			if(module.animated[selector]!=null){
				clearTimeout(module.animated[selector]);
				module.animated[selector] = null;
				var e = document.querySelector(selector);
				if(e){
					e.textContent = clearText;
				}
			}
		}, durationMs)
	}
	return module;
})();