/* Gestion des mouvements du pion bleu */
let myDiv;
let positionOnDown = { x: 0, y: 0 };
let positionOnUp = { x: 0, y: 0 };

function onDown(e) {
  positionOnDown = {
    x: e.clientX,
    y: e.clientY,
  };
  myDiv.ref_ms = {
    x: -(e.offsetX ? e.offsetX : 0) - 5, //taille de la bordure
    y: -(e.offsetY ? e.offsetY : 0) - 5, //taille de la bordure
  };
  myDiv.style.left = myDiv.ref_ms.x + e.clientX + "px";
  myDiv.style.top = myDiv.ref_ms.y + e.clientY + "px";
  myDiv.classList.add("movCursor");
}
function onUp(e) {
  // console.log('onUp'); x
  positionOnUp = {
    x: e.clientX,
    y: e.clientY,
  };
  if (
    positionOnDown.x == positionOnUp.x &&
    positionOnDown.y == positionOnUp.y &&
    (positionOnDown.x > 0 || positionOnDown.y > 0)
  ) {
    var offsetX = (window.innerWidth - 1100) / 2;
    myDiv.style.left = offsetX + steps[players[0].stepTarget].x + "px";
    myDiv.style.top = steps[players[0].stepTarget].y + "px";
  }
  myDiv.classList.remove("movCursor");
}
function onMove(e) {
  // console.log('onMove', e); x
  if (myDiv.classList.contains("movCursor")) {
    myDiv.style.left = myDiv.ref_ms.x + e.clientX + "px";
    myDiv.style.top = myDiv.ref_ms.y + e.clientY + "px";
  }
}

function onResize(e) {
  var pawn = document.querySelector("#pawn-blue");

  if (pawn) {
    var x =
        Number.parseFloat(pawn.style.left.replace(/[^0-9\.]/, "")) - pawn.ref_o,
      y = Number.parseFloat(pawn.style.top.replace(/[^0-9\.]/, ""));
    //console.log('onResize', x, pawn.ref_o)

    var offsetX = (window.innerWidth - 800) / 2;
    pawn.ref_o = offsetX;
    pawn.style.left = x + offsetX + "px";
    pawn.style.top = y + "px";
  }
}

window.addEventListener("DOMContentLoaded", function () {
  myDiv = document.querySelector("#pawn-blue");
  myDiv.ref_ms = { x: 0, y: 0 };

  // Vérifier si l'appareil prend en charge les événements tactiles
  const isTouchDevice =
    "ontouchstart" in window ||
    navigator.maxTouchPoints > 0 ||
    navigator.msMaxTouchPoints > 0;
  if (isTouchDevice) {
    // Si c'est un appareil tactile
    myDiv.addEventListener("touchstart", function () {
      var offsetX = (window.innerWidth - 1100) / 2;
      myDiv.style.left = offsetX + steps[players[0].stepTarget].x + "px";
      myDiv.style.top = steps[players[0].stepTarget].y + "px";
    });
  } else {
    // Si ce n'est pas un appareil tactile
    myDiv.addEventListener("mousedown", onDown);
    window.addEventListener("mousemove", onMove);
    window.addEventListener("mouseup", onUp);
  }

  //on place le pion blue aux bonnes coordonnées
  var pawn = document.querySelector("#pawn-blue");
  if (pawn) {
    //1920x1080 on calcule l'offset en X pour la résolution
    pawn.ref_o = (1920 - 900) / 2;
    pawn.style.left = "618px";
    pawn.style.top = "766px";
    onResize();
  }
  window.addEventListener("resize", function (event) {
    onResize();
  });
  //events in mobile
  //   var lastTouch = null;
  //   myDiv.addEventListener("touchstart", function (e) {

  //     // console.log('touchstart', e, e.touches.length, e.touches[0]); x
  //     if (e.touches.length > 0) {
  //       lastTouch = e.touches[0];
  //       if (lastTouch != null) {
  //         onDown(lastTouch);
  //       }
  //     }
  //   });
  //   window.addEventListener("touchmove", function (e) {
  //     // console.log('touchmove',e); x
  //     if (lastTouch == null) {
  //       return;
  //     }
  //     for (let i = 0; i < e.changedTouches.length; i++) {
  //       if (lastTouch.identifier == e.changedTouches[i].identifier) {
  //         lastTouch = e.changedTouches[i];
  //         onMove(lastTouch);
  //         break;
  //       }
  //     }
  //   });
  //   window.addEventListener("touchend", function (e) {
  //     // console.log('touchend',e); x
  //     if (lastTouch == null) {
  //       return;
  //     }
  //     for (let i = 0; i < e.changedTouches.length; i++) {
  //       if (lastTouch.identifier == e.changedTouches[i].identifier) {
  //         lastTouch = e.changedTouches[i];
  //         onUp(lastTouch);
  //         break;
  //       }
  //     }
  //     lastTouch = null;
  //   });
});
