var v1 = "case de l'oie = red double l'envoi";
var v2 = "6 = red prend le pont jusqu'au 12";
var v3 = "9 par 3 et 6, va au 26";
var v4 = "9 par 4 et 5, va au 53";
var v5 = "MEMO = red passe son tour";
var v6 = "31 = red en réchappe au 30";
var v7 = "42 = red se retrouve au 30";
var v8 = "MEMO = red passe 2 X son tour";
var v9 = "58 = red recommence sa vie à zero";
var v10 = "l'oie ramène en 54";
var v11 = "Fields of joy: on y reste !";
var v12 = "presque !!!";
var v13 = "Stop ! blue a gagné";
var v14 = "Blue gagne, red est bloqué";
var v15 = "{to}"; //anciennement 'Blue va de {from} à {to}'

//positions du centre des cases du jeu
var steps = [
  //case de départ(index=0)
  { x: 260, y: 770 }, // 0
  { x: 340, y: 770 }, // 1
  { x: 420, y: 770 }, // 2
  { x: 520, y: 770 }, // 3
  { x: 580, y: 770 }, // 4
  { x: 650, y: 770 }, // 5
  //case 6(index=6)
  { x: 690, y: 770 }, // 6
  { x: 880, y: 765 }, // 7
  { x: 930, y: 710 }, // 8
  { x: 930, y: 600 }, // 9
  { x: 930, y: 510 }, // 10
  { x: 930, y: 430 }, // 11
  //case 12(index=12)
  { x: 930, y: 335 }, // 12
  { x: 930, y: 245 }, // 13
  { x: 930, y: 170 }, // 14
  { x: 930, y: 70 }, // 15
  { x: 850, y: 15 }, // 16
  { x: 780, y: 0 }, // 17
  //case 18
  { x: 660, y: 0 }, // 18
  { x: 600, y: 0 }, // 19
  { x: 500, y: 0 }, // 20
  { x: 420, y: 0 }, // 21
  { x: 340, y: 0 }, // 22
  { x: 250, y: 0 }, // 23
  //case 24
  { x: 150, y: 10 }, // 24
  { x: 100, y: 80 }, // 25
  { x: 100, y: 170 }, // 26
  { x: 100, y: 300 }, // 27
  { x: 100, y: 360 }, // 28
  { x: 100, y: 450 }, // 29
  //case 30
  { x: 100, y: 550 }, // 30
  { x: 100, y: 660 }, // 31
  { x: 240, y: 660 }, // 32
  { x: 330, y: 660 }, // 33
  { x: 395, y: 660 }, // 34
  { x: 500, y: 660 }, // 35
  //case 36
  { x: 610, y: 660 }, // 36
  { x: 680, y: 660 }, // 37
  { x: 780, y: 660 }, // 38
  { x: 790, y: 550 }, // 39
  { x: 790, y: 470 }, // 40
  { x: 790, y: 380 }, // 41
  //case 42
  { x: 790, y: 329 }, // 42
  { x: 790, y: 230 }, // 43
  { x: 790, y: 160 }, // 44
  { x: 750, y: 140 }, // 45
  { x: 690, y: 120 }, // 46
  { x: 620, y: 120 }, // 47
  //case 48
  { x: 550, y: 120 }, // 48
  { x: 480, y: 120 }, // 49
  { x: 400, y: 120 }, // 50
  { x: 330, y: 120 }, // 51
  { x: 250, y: 120 }, // 52
  { x: 240, y: 180 }, // 53
  //case 54
  { x: 240, y: 240 }, // 54
  { x: 240, y: 300 }, // 55
  { x: 240, y: 360 }, // 56
  { x: 240, y: 420 }, // 57
  { x: 240, y: 470 }, // 58
  { x: 240, y: 555 }, // 59
  //case 60
  { x: 320, y: 555 }, // 60
  { x: 390, y: 555 }, // 61
  { x: 470, y: 555 }, // 62
  //case 63
  { x: 540, y: 555 }, // 63
  //faux cases pour le rebond
  { x: 470, y: 555 }, // 62
  { x: 400, y: 555 }, // 61
  { x: 330, y: 555 }, // 60
  { x: 220, y: 555 }, // 59
  { x: 220, y: 500 }, // 58
  { x: 220, y: 410 }, // 57
  { x: 220, y: 350 }, // 56
  { x: 220, y: 295 }, // 55
  { x: 220, y: 250 }, // 54
  { x: 220, y: 180 }, // 53
  { x: 220, y: 100 }, // 52
  { x: 300, y: 100 }, // 51
];

//fonction qui affiche un texte pour dire ce qui se passe
var gameTextDuration = 16000; //10 secondes
function setGameText(msg) {
  TextAnimation.setText("#infotext", msg, gameTextDuration, "infotext");
}
//effet de la dernière case en cas de trop-plein
function boomrang(player) {
  if (player.stepTarget > 63) {
    player.step = 63;
    player.stepTarget = 63 - (player.stepTarget - 63);
    if (player.pawn != "red") return;
    setGameText(v12);
  }
}
//effet doubleBond
function doubleBond(player) {
  player.stepTarget = player.stepTarget + getTotalDices(player.lastDices);
  if (player.pawn != "red") return;
  setGameText(v1);
}
//liste des cases avec un effet particulier
var stepEffects = {
  6: function (player) {
    player.stepTarget = 12;
    if (player.pawn != "red") return;
    setGameText(v2);
  },
  9: function (player) {
    if (
      (player.lastDices[0] == 6 && player.lastDices[1] == 3) ||
      (player.lastDices[0] == 3 && player.lastDices[1] == 6)
    ) {
      player.stepTarget = 26;
      if (player.pawn != "red") return;
      setGameText(v3);
    } else if (
      (player.lastDices[0] == 4 && player.lastDices[1] == 5) ||
      (player.lastDices[0] == 5 && player.lastDices[1] == 4)
    ) {
      player.stepTarget = 53;
      if (player.pawn != "red") return;
      setGameText(v4);
    }
  },
  18: doubleBond,
  19: function (player) {
    if (player.pawn != "red") return;
    setGameText(v5);
  },
  27: doubleBond,
  31: function (player) {
    player.stepTarget = 30;
    if (player.pawn != "red") return;
    setGameText(v6);
  },
  36: doubleBond,
  42: function (player) {
    player.stepTarget = 30;
    if (player.pawn != "red") return;
    setGameText(v7);
  },
  45: doubleBond,
  52: function (player) {
    if (player.pawn != "red") return;
    setGameText(v8);
  },
  54: doubleBond,
  58: function (player) {
    player.stepTarget = 0;

    if (player.pawn != "red") return;
    setGameText(v9);
    players[1].step = 0;
  },
  // 58: function(player){
  // 	player.stepTarget = 0;
  // 	if(player.pawn!='red') return;
  // 	setGameText(v9);
  // },
  59: function (player) {
    player.stepTarget = 54;
    if (player.pawn != "red") return;
    setGameText(v10);
  },
  63: function (player) {
    if (player.pawn != "red") return;
    setGameText(v11);
  },
  64: boomrang, //62 + 2
  65: boomrang, //62 + 3
  66: boomrang, //62 + 4
  67: boomrang, //62 + 5
  68: boomrang, //62 + 6
  69: boomrang, //62 + 7
  70: boomrang, //62 + 8
  71: boomrang, //62 + 9
  72: boomrang, //62 + 10
  73: boomrang, //62 + 11
  74: boomrang, //62 + 12
};
//nombre de dés
var nbsDices = 2;
//listes des joueurs
var players = [
  {
    pawn: "blue",
    step: 0,
    wait: 0,
    stepTarget: 0,
    lastDices: [0, 0],
    isIA: false,
    lastStepEffects: [],
    isLooped: false,
  },
  {
    pawn: "red",
    step: 0,
    wait: 0,
    stepTarget: 0,
    lastDices: [0, 0],
    isIA: true,
    lastStepEffects: [],
    isLooped: false,
  },
];
//fonction qui génère le lancer de dés
var forceDices = null;
function giveRndDices() {
  var r = [];
  //permet de tester avec un jet de dés spécifiques
  if (forceDices != null && forceDices.length == nbsDices) {
    return forceDices;
  }
  for (var i = 0; i < nbsDices; i++) {
    r.push(Math.floor(1 + Math.random() * 6));
  }
  return r;
}
//fonction qui additionne les ds
function getTotalDices(dices) {
  var r = 0;
  for (var i = 0; i < dices.length; i++) {
    r += dices[i];
  }
  return r;
}
//fonction qui joue à la place d'un joueur
function doPlay(playerIndex) {
  players[playerIndex].lastDices = giveRndDices();
  players[playerIndex].stepTarget =
    players[playerIndex].step + getTotalDices(players[playerIndex].lastDices);
  players[1].lastStepEffects = [];
}
//fonction passe au joueur suivant
function endTurn() {
  console.log("endTurn of player:", JSON.parse(JSON.stringify(players[1])));
  if (players[1].wait > 0) {
    players[1].wait--;
  } else if (players[1].step in stepEffects) {
    if (players[1].lastStepEffects.indexOf(players[1].step) == -1) {
      console.log("stepEffects!");
      players[1].lastStepEffects.push(players[1].step);
      stepEffects[players[1].step](players[1]);
      if (players[1].step != players[1].stepTarget) {
        checkAnimation();
        return;
      }
    } else {
      players[1].isLooped = true;
      setGameText(v14);
    }
  }
  renderGame();
}
//(ré)initialise les variables de jeu
function initGameVarsAndHTML() {
  players[1].step = 0;
  players[1].stepTarget = 0;
  renderGame();
}
//"moteur de rendu" du jeu
function renderGame() {
  if (isAnimated()) return;
  for (var j = 0; j < nbsDices; j++) {
    setDiceFace(1, j, players[1].lastDices[j]);
  }
  var pawn = getPawn(1);
  if (pawn) {
    setPawnPosition(1, steps[players[1].step].x, steps[players[1].step].y);
  }
}
//fonction graphique qui renvoie le pion du joueur
function getPawn(playerIndex) {
  return document.querySelector("#pawn-" + players[playerIndex].pawn);
}
//fonction pour placer le pion au bonnes coordonnées si la résolution de l'écran est différente de 1920x1080
function setPawnPosition(playerIndex, x, y) {
  //on désactive le déplacement du pion blue qui appartient à joueur.
  if (playerIndex == 0) return false;
  //il faut retirer la marge à gauche selon la résolution de la fenètre
  var offsetX = (1100 - window.innerWidth) / 2;
  getPawn(playerIndex).style.left = x - offsetX + "px";
  getPawn(playerIndex).style.top = y + "px";
}
//fonction graphique qui renvoie l'un des dés du joueur
function getDice(playerIndex, diceIndex) {
  return document.querySelector("#dice-" + playerIndex + "-" + diceIndex);
}
//fonction graphique qui change la face du dés
function setDiceFace(playerIndex, diceIndex, value) {
  var dice = getDice(playerIndex, diceIndex);
  if (dice) {
    if (value == 0) {
      dice.src = "Images/0a.png";
    } else if (value > 0 && value < 7) {
      dice.src = "Images/" + Math.floor(value) + ".png";
    } else {
      console.warn("invalid dice value:", playerIndex, diceIndex);
    }
  } else {
    console.warn("invalid dice indexes:", playerIndex, diceIndex);
  }
}
//liste des animations à faire
var toAnimate = [];
var animTimer = null;
var animFrame = 0;
//nombre d'étape de 50millisecondes par animation(10 => 0.5secondes)
var frameStep = 10;
var msPerFrame = 25;
var checkAnimation;
function isAnimated() {
  return toAnimate.length > 0 || animTimer != null;
}
function hasAnimation(animDef) {
  var hash = JSON.stringify(animDef);
  for (var i = 0; i < toAnimate.length; i++) {
    if (JSON.stringify(toAnimate[i]) == hash) return true;
  }
  return false;
}
checkAnimation = function () {
  //console.log('toAnimate:', JSON.parse(JSON.stringify(toAnimate)), animTimer);
  if ((animTimer = null)) {
    clearTimeout(animTimer);
    animTimer = null;
  }
  //si on a une animation à gérer, on la gère ici
  if (toAnimate.length > 0) {
    var anim = toAnimate[0];
    //définir ici les animations
    if (anim.op == "move") {
      var dx = (steps[anim.to].x - steps[anim.from].x) / frameStep;
      var dy = (steps[anim.to].y - steps[anim.from].y) / frameStep;

      var pawn = getPawn(anim.who);
      setPawnPosition(
        anim.who,
        steps[anim.from].x + Math.floor(dx * animFrame),
        steps[anim.from].y + Math.floor(dy * animFrame)
      );
      if (animFrame == frameStep) {
        players[anim.who].step = anim.to;
        players[anim.who].stepTarget = anim.to;
      }
    }

    //si l'animation est fini, (0.5secondes)
    if (animFrame >= frameStep) {
      animFrame = 0;
      //on retire l'animation finie
      toAnimate = toAnimate.slice(1);
    }
    animFrame++;
  }
  //si l'animation n'est pas dans la liste toAnimate, on l'ajoute
  var anim = null;
  //animation de déplacement
  if (players[1].step != players[1].stepTarget) {
    //console.log('player ' + players[1].pawn + ' must move!');
    var from = players[1].step;
    var to = players[1].stepTarget;
    while (from != to) {
      anim = {
        op: "move",
        who: 1,
        from: from,
        to: from + (from < to ? 1 : -1),
      };
      if (from == 63 && to > 63) {
        anim.to = to;
      }
      from = anim.to;
      if (anim != null && !hasAnimation(anim)) {
        //console.log('add animation!');
        toAnimate.push(anim);
      }
    }
  }

  if (toAnimate.length > 0) {
    animTimer = setTimeout(checkAnimation, msPerFrame);
  } else {
    animTimer = null;
    //on appelle endTurn pour appliquer les effets de la case
    endTurn();
  }
};
var animPlayer = false;
//affiche la future position de blue
function showBluePos(e) {
  var bluePosElement = document.querySelector("#doctxt");
  if (!bluePosElement) return;
  //si l'appel de la fonction se fait depuis le bouton alors on cache si c'est affiché
  if (e) {
    if (bluePosElement.textContent.length > 0) {
      bluePosElement.textContent = "";
      return;
    }
    bluePosElement.textContent = v15
      .replace("{from}", players[0].step)
      .replace("{to}", players[0].stepTarget);
  }
  //sinon on met à jours si c'est affiché
  else {
    if (bluePosElement.textContent.length > 0) {
      bluePosElement.textContent = v15
        .replace("{from}", players[0].step)
        .replace("{to}", players[0].stepTarget);
    }
  }
}
//calcule les effets des cases sur blue
function checkBlueStepEffets(player) {
  if (player.isLooped) return;
  while (player.stepTarget in stepEffects) {
    if (player.lastStepEffects.indexOf(player.stepTarget) == -1) {
      player.lastStepEffects.push(player.stepTarget);
      var lastStep = player.stepTarget;
      stepEffects[lastStep](player);
      //si on n'a pas bougé c'est que l'effet est de passé son tour?
      if (lastStep == player.stepTarget) {
        break;
      }
    } else {
      player.isLooped = true;
      console.log("player blocked in loop!");
      break;
    }
  }
}
//ajoute les events sur les boutons et la fenètre
window.addEventListener("DOMContentLoaded", function () {
  setGameText("infotext");
  window.addEventListener("resize", function (event) {
    renderGame();
  });
  document.querySelector(".charte").addEventListener("click", function (e) {
    e.preventDefault();
    e.stopImmediatePropagation();
    popupcentree("charte.html", 450, 450, "menubar=no,statusbar=no");
    return false;
  });
  document.querySelector("#bu_rolldice").addEventListener("click", function () {
    players[0].lastDices = giveRndDices();
    setDiceFace(0, 0, players[0].lastDices[0]);
    setDiceFace(0, 1, players[0].lastDices[1]);
    if (players[0].isLooped) return;
    if (players[0].stepTarget == 63) {
      return;
    }
    players[0].lastStepEffects = [];
    players[0].step = players[0].stepTarget;
    players[0].stepTarget =
      players[0].step + getTotalDices(players[0].lastDices);
    checkBlueStepEffets(players[0]);
    showBluePos();
  });
  document
    .querySelector("#bia_rolldice")
    .addEventListener("click", function () {
      // on bloque red sur 63 s'il a gagné
      if (players[1].step == 63 && players[1].stepTarget == 63) {
        return;
      }
      //si red a été bloqué dans une boucle, on bloque red définitement
      if (players[1].isLooped) {
        setGameText(v14);
        return;
      }
      //s'il y a une animation on empèche de jouer
      if (isAnimated()) return;
      doPlay(1);
      renderGame();
      checkAnimation();
      if (toAnimate.length == 0) {
        endTurn();
        renderGame();
      }
    });
  document.querySelector("#doc").addEventListener("click", showBluePos);
  initGameVarsAndHTML();
});
